//
// (c) 2023 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Create 1.0
import wesual.Nodes  1.0
import wesual.Ui     1.0

UiDropDown {
    id : picker

    property string documentType

    readonly property var presets : {
        const presetList = [ { id: "", name: "" } ];

        for (let i = 0; i < Creator.typeInfos.length; ++i) {
            const info = Creator.typeInfos[i];
            presetList.push({
                id: info.id,
                name: info.name
            });
        }

        return presetList;
    }

    signal documentTypePicked(string documentType)

    labelDelegate : UiText {
        text : {
            const info = Creator.typeInfo(documentType);
            if (info) {
                return info.name;
            }

            return documentType;
        }
    }

    model : presets

    bindable : true
    currentIndex : {
        for (let i = 0; i < presets.length - 1; ++i) {
            if (presets[i].id === documentType) {
                return i;
            }
        }

        return 0;
    }

    onIndexPicked : picker.documentTypePicked(presets[index].id)
}
